# QuickSnip

QuickSnip is an open-source tool designed for developers who want to organize, search, and share code snippets across various programming languages. It provides a centralized platform for managing handy snippets. Built with love and powered by an awesome community. 🚀

<div>
<a href="https://youtu.be/BhRi7fJzPgk?si=z1sVXU7uRS0bkSEt" target="_blank">
  <img src="https://img.shields.io/static/v1?label=&message=Watch%20on%20YouTube&labelColor=FFFFFF&color=FF0000&style=for-the-badge&logo=youtube&logoColor=FF0000" alt="Watch on YouTube">
</a>
<div>

<br>

![Website preview](/preview.png)

## How to Contribute

Want to help make QuickSnip even better? You can contribute by:

- **Improving the Code**: Fix bugs, suggest new features, or optimize the project.
- **Adding New Snippets**: Share your favorite snippets to grow the database.

Check out the [CONTRIBUTING.md](/CONTRIBUTING.md) file for detailed contribution guidelines.

## General Rules

To keep everything smooth and consistent, please:

- [x] Follow the project’s style and contribution rules.
- [x] Be kind and respectful to others.
- [x] If you’re unsure, ask questions.

Following these rules helps us build an awesome community. 🚀

## Third-Party

We love to see the creativity of our community! If you build something using QuickSnip, let us know. Here are some featured examples:

- ⚡️ [**Raycast Extension**](https://www.raycast.com/anders_morille/quicksnip): An extension to browse and use QuickSnip snippets directly from Raycast. (Thanks to the creator: [@lille-morille](https://github.com/lille-morille))

If you’d like to create your own extension or tool:

- [x] Please ensure it adheres to our project’s licensing and attribution requirements.
- [x] Please link to the [original QuickSnip repository](https://github.com/technoph1le/quicksnip) in your extension/tool to attribute the source.
- [x] Share your work with us — we’d be thrilled to feature it!

## Project Vision

For a detailed look into our goals, future direction, and aspirations, see the [VISION.md](/VISION.md) file.

## License

QuickSnip is licensed under the [MIT License](/LICENSE). Feel free to use and share it as you like.

<a href="https://www.producthunt.com/products/quicksnip" target="_blank" style="text-decoration: none;">
  <img src="https://img.shields.io/static/v1?label=&message=Leave%20a%20Review&labelColor=FFFFFF&color=DA552F&style=for-the-badge&logo=product-hunt&logoColor=DA552F" alt="Leave a Review">
</a>
