import { source } from "@/lib/source";
import {
  DocsBody,
  DocsDescription,
  DocsPage,
  DocsTitle,
} from "fumadocs-ui/page";
import { getGithubLastEdit } from "fumadocs-core/server";
import { notFound } from "next/navigation";
import { getMDXComponents } from "../../../../mdx-components";

export default async function Page(props: {
  params: Promise<{ slug?: string[] }>;
}) {
  const params = await props.params;

  const page = source.getPage(params.slug);
  if (!page) notFound();

  const MDX = page.data.body;
  const time = await getGithubLastEdit({
    owner: "fuma-nama",
    repo: "fumadocs",
    path: `content/guide/${page.path}`,
  });

  return (
    <DocsPage
      editOnGithub={{
        owner: "quicksnip-dev",
        repo: "quicksnip",
        path: `content/guide/${page.path}`,
      }}
      lastUpdate={time ? new Date(time) : undefined}
      full={page.data.full}
    >
      <DocsTitle>{page.data.title}</DocsTitle>
      <DocsDescription>{page.data.description}</DocsDescription>
      <DocsBody>
        <MDX components={getMDXComponents()} />
      </DocsBody>
    </DocsPage>
  );
}

export async function generateStaticParams() {
  return source.generateParams();
}

export async function generateMetadata(props: {
  params: Promise<{ slug?: string[] }>;
}) {
  const params = await props.params;
  const page = source.getPage(params.slug);
  if (!page) notFound();

  return {
    title: page.data.title,
    description: page.data.description,
  };
}
