import Link from "next/link";

export const LogoIcon = () => (
  <svg
    width="43"
    height="30"
    viewBox="0 0 43 30"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    role="img"
    aria-labelledby="qs-logo-title qs-logo-description"
  >
    <title id="qs-logo-title">QuickSnip Logo</title>
    <desc id="qs-logo-description">
      A light blue logo with a thunderbolt in brackets
    </desc>
    <path
      d="M11.0123 3.81725C8.81785 3.81725 7.7866 4.47726 7.9186 5.79726L8.4136 10.871C8.4301 11.0195 8.43835 11.234 8.43835 11.5145C8.43835 12.3065 8.2486 12.917 7.8691 13.346C7.4896 13.7585 6.90385 14.039 6.11185 14.1875C6.92035 14.336 7.5061 14.6165 7.8691 15.029C8.2486 15.425 8.43835 16.0273 8.43835 16.8358C8.43835 17.1163 8.4301 17.339 8.4136 17.504L7.9186 22.5778C7.8526 23.3038 8.1001 23.8153 8.6611 24.1123C9.2221 24.4093 10.0058 24.5578 11.0123 24.5578V26.216C9.52735 26.216 8.3146 25.9603 7.3741 25.4488C6.4336 24.9373 5.96335 24.071 5.96335 22.85C5.96335 22.6355 5.9716 22.4705 5.9881 22.355L6.50785 17.6525C6.52435 17.537 6.5326 17.372 6.5326 17.1575C6.5326 16.4315 6.26035 15.8953 5.71585 15.5488C5.17135 15.2023 4.18135 15.029 2.74585 15.029V13.346C4.18135 13.346 5.17135 13.181 5.71585 12.851C6.26035 12.5045 6.5326 11.9683 6.5326 11.2423C6.5326 11.0443 6.52435 10.8875 6.50785 10.772L5.9881 6.02001C5.9716 5.90451 5.96335 5.73951 5.96335 5.525C5.96335 4.304 6.4336 3.43775 7.3741 2.92625C8.3146 2.41476 9.52735 2.15901 11.0123 2.15901V3.81725Z"
      fill="#00b5b8"
    />
    <path
      d="M30.6782 13.2235L18.41 25.8383C18.0691 26.1878 17.5037 25.7829 17.7253 25.3482L22.0922 16.7309C22.1252 16.6659 22.1411 16.5935 22.1381 16.5206C22.1352 16.4477 22.1136 16.3767 22.0754 16.3146C22.0372 16.2524 21.9836 16.2011 21.9199 16.1656C21.8562 16.13 21.7844 16.1114 21.7114 16.1116H12.5259C12.442 16.1115 12.36 16.0867 12.2902 16.0402C12.2203 15.9937 12.1658 15.9277 12.1333 15.8503C12.1008 15.7729 12.0919 15.6877 12.1077 15.6053C12.1235 15.5229 12.1632 15.447 12.2219 15.3871L23.6008 3.85901C23.9304 3.52517 24.4787 3.89169 24.2955 4.32496L21.0324 12.0174C21.0048 12.0827 20.9938 12.1537 21.0006 12.2242C21.0073 12.2947 21.0315 12.3625 21.071 12.4213C21.1105 12.4801 21.164 12.5281 21.2267 12.561C21.2894 12.5939 21.3593 12.6107 21.4302 12.6098L30.3671 12.499C30.4514 12.4977 30.5343 12.5214 30.6051 12.5671C30.676 12.6129 30.7317 12.6786 30.7651 12.7561C30.7986 12.8335 30.8083 12.9191 30.7931 13.0021C30.7779 13.085 30.7384 13.1616 30.6796 13.2221L30.6782 13.2235Z"
      stroke="#00b5b8"
      strokeWidth="1.65"
    />
    <path
      d="M31.7378 2.15901C33.2228 2.15901 34.4355 2.41476 35.376 2.92625C36.3165 3.43775 36.7868 4.304 36.7868 5.525C36.7868 5.73951 36.7785 5.90451 36.762 6.02001L36.2423 10.772C36.2258 10.8545 36.2175 10.9783 36.2175 11.1433C36.2175 11.8858 36.5063 12.4385 37.0838 12.8015C37.6778 13.1645 38.6513 13.346 40.0043 13.346V15.029C38.6348 15.029 37.6613 15.2105 37.0838 15.5735C36.5063 15.9365 36.2175 16.4975 36.2175 17.2565C36.2175 17.4215 36.2258 17.5535 36.2423 17.6525L36.762 22.355C36.7785 22.4705 36.7868 22.6355 36.7868 22.85C36.7868 24.071 36.3165 24.9373 35.376 25.4488C34.4355 25.9603 33.2228 26.216 31.7378 26.216V24.5578C32.7443 24.5578 33.528 24.4093 34.089 24.1123C34.65 23.8153 34.8975 23.3038 34.8315 22.5778L34.3365 17.504C34.3035 17.174 34.287 16.9513 34.287 16.8358C34.287 16.0108 34.4933 15.4003 34.9058 15.0043C35.3183 14.6083 35.9865 14.3443 36.9105 14.2123C36.0195 14.0473 35.3595 13.7585 34.9305 13.346C34.518 12.917 34.3118 12.2983 34.3118 11.4898C34.3118 11.2258 34.32 11.0195 34.3365 10.871L34.8315 5.79726C34.9635 4.47726 33.9323 3.81725 31.7378 3.81725V2.15901Z"
      fill="#00b5b8"
    />
  </svg>
);

const Logo = () => {
  return (
    <Link href="/" className="flex items-center gap-2">
      <LogoIcon />
      <span className="font-bold text-lg">QuickSnip</span>
    </Link>
  );
};

export default Logo;
