/*
 * Scala.js (https://www.scala-js.org/)
 *
 * Copyright EPFL.
 *
 * Licensed under Apache License 2.0
 * (https://www.apache.org/licenses/LICENSE-2.0).
 *
 * See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 */

package scala.scalajs

import scala.annotation.tailrec

import scala.scalajs.LinkingInfo.{isWebAssembly, linkTimeIf}

package object runtime {

  import scala.scalajs.runtime.Compat._

  @deprecated("Unused by the codegen; use js.special.wrapAsThrowable instead", "1.11.0")
  @inline def wrapJavaScriptException(e: Any): Throwable =
    js.special.wrapAsThrowable(e)

  @deprecated("Unused by the codegen; use js.special.unwrapFromThrowable instead", "1.11.0")
  @inline def unwrapJavaScriptException(th: Throwable): Any =
    js.special.unwrapFromThrowable(th)

  @inline def toScalaVarArgs[A](array: js.Array[A]): Seq[A] =
    toScalaVarArgsImpl(array)

  @inline def toJSVarArgs[A](seq: Seq[A]): js.Array[A] =
    toJSVarArgsImpl(seq)

  /* Factories for varargs seqs.
   *
   * The compiler backend introduces calls to these methods, instead of the
   * default {Predef,ScalaRunTime}.wrap*Array methods. They choose the best
   * implementation of Seq for varargs depending on the target.
   *
   * On Wasm, we use sci.ArraySeq/scm.WrappedArray, like on the JVM.
   * On JavaScript, we convert the Scala arrays to JS arrays and use
   * scala.scalajs.runtime.WrappedVarArgs/WrappedArray.
   *
   * The conversions from Scala array to JS array are intrinsified by the
   * optimizer, which directly creates a JS array from the start, instead of
   * creating a temporary Scala array.
   *
   * We use linkTimeIf's not to have any regression compared to the code
   * generated by Scala.js < 1.20.0, where we unconditionally generated calls
   * to toScalaVarArgs with JS arrays.
   */

  @inline def toGenericVarArgs[T](xs: Array[T]): Seq[T] =
    linkTimeIf[Seq[T]](isWebAssembly)(toGenericVarArgsWasmImpl(xs))(toScalaVarArgs(genericArrayToJSArray(xs)))

  @inline def toRefVarArgs[T <: AnyRef](xs: Array[T]): Seq[T] =
    linkTimeIf[Seq[T]](isWebAssembly)(toRefVarArgsWasmImpl[T](xs))(toScalaVarArgs(refArrayToJSArray(xs)))

  @inline def toUnitVarArgs(xs: Array[Unit]): Seq[Unit] =
    linkTimeIf[Seq[Unit]](isWebAssembly)(toUnitVarArgsWasmImpl(xs))(toScalaVarArgs(unitArrayToJSArray(xs)))

  @inline def toBooleanVarArgs(xs: Array[Boolean]): Seq[Boolean] =
    linkTimeIf[Seq[Boolean]](isWebAssembly)(toBooleanVarArgsWasmImpl(xs))(toScalaVarArgs(booleanArrayToJSArray(xs)))

  @inline def toCharVarArgs(xs: Array[Char]): Seq[Char] =
    linkTimeIf[Seq[Char]](isWebAssembly)(toCharVarArgsWasmImpl(xs))(toScalaVarArgs(charArrayToJSArray(xs)))

  @inline def toByteVarArgs(xs: Array[Byte]): Seq[Byte] =
    linkTimeIf[Seq[Byte]](isWebAssembly)(toByteVarArgsWasmImpl(xs))(toScalaVarArgs(byteArrayToJSArray(xs)))

  @inline def toShortVarArgs(xs: Array[Short]): Seq[Short] =
    linkTimeIf[Seq[Short]](isWebAssembly)(toShortVarArgsWasmImpl(xs))(toScalaVarArgs(shortArrayToJSArray(xs)))

  @inline def toIntVarArgs(xs: Array[Int]): Seq[Int] =
    linkTimeIf[Seq[Int]](isWebAssembly)(toIntVarArgsWasmImpl(xs))(toScalaVarArgs(intArrayToJSArray(xs)))

  @inline def toLongVarArgs(xs: Array[Long]): Seq[Long] =
    linkTimeIf[Seq[Long]](isWebAssembly)(toLongVarArgsWasmImpl(xs))(toScalaVarArgs(longArrayToJSArray(xs)))

  @inline def toFloatVarArgs(xs: Array[Float]): Seq[Float] =
    linkTimeIf[Seq[Float]](isWebAssembly)(toFloatVarArgsWasmImpl(xs))(toScalaVarArgs(floatArrayToJSArray(xs)))

  @inline def toDoubleVarArgs(xs: Array[Double]): Seq[Double] =
    linkTimeIf[Seq[Double]](isWebAssembly)(toDoubleVarArgsWasmImpl(xs))(toScalaVarArgs(doubleArrayToJSArray(xs)))

  // Intrinsics to convert arrays to JS arrays

  @inline
  private def arrayToJSArrayImpl[T](array: Array[T]): js.Array[T] = {
    val len = array.length
    val result = js.Array[T]()
    var i = 0
    while (i != len) {
      result.push(array(i))
      i += 1
    }
    result
  }

  @noinline def genericArrayToJSArray[T](array: Array[T]): js.Array[T] =
    arrayToJSArrayImpl(array)
  @noinline def refArrayToJSArray[T <: AnyRef](array: Array[T]): js.Array[T] =
    arrayToJSArrayImpl(array)
  @noinline def unitArrayToJSArray(array: Array[Unit]): js.Array[Unit] =
    arrayToJSArrayImpl(array)
  @noinline def booleanArrayToJSArray(array: Array[Boolean]): js.Array[Boolean] =
    arrayToJSArrayImpl(array)
  @noinline def charArrayToJSArray(array: Array[Char]): js.Array[Char] =
    arrayToJSArrayImpl(array)
  @noinline def byteArrayToJSArray(array: Array[Byte]): js.Array[Byte] =
    arrayToJSArrayImpl(array)
  @noinline def shortArrayToJSArray(array: Array[Short]): js.Array[Short] =
    arrayToJSArrayImpl(array)
  @noinline def intArrayToJSArray(array: Array[Int]): js.Array[Int] =
    arrayToJSArrayImpl(array)
  @noinline def longArrayToJSArray(array: Array[Long]): js.Array[Long] =
    arrayToJSArrayImpl(array)
  @noinline def floatArrayToJSArray(array: Array[Float]): js.Array[Float] =
    arrayToJSArrayImpl(array)
  @noinline def doubleArrayToJSArray(array: Array[Double]): js.Array[Double] =
    arrayToJSArrayImpl(array)

  /** Dummy method used to preserve the type parameter of
   *  `js.constructorOf[T]` through erasure.
   *
   *  An early phase of the compiler reroutes calls to `js.constructorOf[T]`
   *  into `runtime.constructorOf(classOf[T])`.
   *
   *  The `clazz` parameter must be a literal `classOf[T]` constant such that
   *  `T` represents a class extending `js.Any` (not a trait nor an object).
   */
  def constructorOf(clazz: Class[_ <: js.Any]): js.Dynamic =
    throw new Error("stub")

  /** Public access to `new ConstructorTag` for the codegen of
   *  `js.ConstructorTag.materialize`.
   */
  def newConstructorTag[T <: js.Any](constructor: js.Dynamic): js.ConstructorTag[T] =
    new js.ConstructorTag[T](constructor)

  /** Dummy method used to preserve where and how an inner JS class should be
   *  created.
   *
   *  @param clazz `classOf` of the class to be created
   *  @param superClass JS class value of the super class
   */
  def createInnerJSClass(clazz: Class[_], superClass: AnyRef): AnyRef =
    throw new Error("stub")

  /** Dummy method used to preserve where and how a local JS class should be
   *  created.
   *
   *  @param clazz
   *    `classOf` of the class to be created
   *  @param superClass
   *    JavaScript class value of the super class
   *  @param fakeNewInstances
   *    Fake `New` instantiations used to retrieve actual capture params
   */
  def createLocalJSClass(clazz: Class[_], superClass: AnyRef,
      fakeNewInstances: Array[AnyRef]): AnyRef = {
    throw new Error("stub")
  }

  /** Dummy method used to preserve a JS class value term associated with an
   *  expression tree.
   *
   *  This is used for:
   *  - New instances of nested JS classes and objects
   *  - Super calls in nested JS classes
   *
   *  @param jsclass
   *    The contextual JS class value
   *  @param inner
   *    The original inner tree
   */
  def withContextualJSClassValue[A](jsclass: AnyRef, inner: A): A =
    throw new Error("stub")

  @inline
  def privateFieldsSymbol(): Any =
    PrivateFieldsSymbolHolder.privateFieldsSymbol

  /** Information known at link-time, given the output configuration.
   *
   *  See [[LinkingInfo]] for details.
   */
  @deprecated(
      "Use scala.scalajs.LinkingInfo instead. " +
      "For fileLevelThis, use scala.scalajs.js.special.fileLevelThis.",
      since = "1.18.0")
  def linkingInfo: LinkingInfo = new LinkingInfo {
    override val esVersion: Int = scalajs.LinkingInfo.esVersion
    override val assumingES6: Boolean = scalajs.LinkingInfo.assumingES6
    override val isWebAssembly: Boolean = scalajs.LinkingInfo.isWebAssembly
    override val productionMode: Boolean = scalajs.LinkingInfo.productionMode
    override val linkerVersion: String = scalajs.LinkingInfo.linkerVersion
    override val fileLevelThis: Any = js.special.fileLevelThis
  }

  /** Identity hash code of an object. */
  @deprecated("Unused; use System.identityHashCode(x) instead.", since = "1.20.0")
  def identityHashCode(x: Object): Int =
    System.identityHashCode(x)

  def dynamicImport[A](thunk: DynamicImportThunk): js.Promise[A] =
    throw new Error("stub")
}
