/*
 * Scala.js (https://www.scala-js.org/)
 *
 * Copyright EPFL.
 *
 * Licensed under Apache License 2.0
 * (https://www.apache.org/licenses/LICENSE-2.0).
 *
 * See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 */

package org.scalajs.linker.backend.wasmemitter

object EmbeddedConstants {
  /** Module name of the JS string builtins.
   *
   *  Unlike the other module names below, this one is spec'ed by the JS string
   *  builtins proposal. It is not configurable.
   */
  final val JSStringBuiltinsModule = "wasm:js-string"

  /** Module for our core helpers, defined by hand in `LoaderContent`. */
  final val CoreHelpersModule = "__scalaJSHelpers"

  /** Module containing the export setters, generated by the `Emitter`. */
  final val ExportSettersModule = "__scalaJSExportSetters"

  /** Module containing the getters for private JS fields. */
  final val PrivateJSFieldGetters = "privateJSFieldGetters"

  /** Module containing the setters for private JS fields. */
  final val PrivateJSFieldSetters = "privateJSFieldSetters"

  /** Module containing the custom JS helpers (see CustomJSHelperBuilder). */
  final val CustomHelpersModule = "__scalaJSCustomHelpers"

  /** Wasm module for builtin string constants using the JS string builtins proposal.
   *
   *  We use the recommended trick of using the empty string here, to minimize
   *  code size bloat. This string gets duplicated for every string literal in
   *  the codebase.
   */
  final val UTF8StringConstantsModule = ""

  /** Imported modules for WTF-16 strings, which cannot use the JS string builtins. */
  final val WTF16StringConstantsModule = "wtf16Strings"

  /* Values returned by the `jsValueType` helper.
   *
   * 0: false
   * 1: true
   * 2: string
   * 3: number
   * 4: undefined
   * 5: everything else
   *
   * This encoding has the following properties:
   *
   * - false and true also return their value as the appropriate i32.
   * - the types implementing `Comparable` are consecutive from 0 to 3.
   */

  final val JSValueTypeFalse = 0
  final val JSValueTypeTrue = 1
  final val JSValueTypeString = 2
  final val JSValueTypeNumber = 3
  final val JSValueTypeUndefined = 4
  final val JSValueTypeBigInt = 5
  final val JSValueTypeSymbol = 6
  final val JSValueTypeOther = 7

  // Values for `typeData.kind`

  final val KindVoid = 0
  final val KindBoolean = 1
  final val KindChar = 2
  final val KindByte = 3
  final val KindShort = 4
  final val KindInt = 5
  final val KindLong = 6
  final val KindFloat = 7
  final val KindDouble = 8
  final val KindArray = 9
  final val KindObject = 10 // j.l.Object
  final val KindBoxedUnit = 11
  final val KindBoxedBoolean = 12
  final val KindBoxedCharacter = 13
  final val KindBoxedByte = 14
  final val KindBoxedShort = 15
  final val KindBoxedInteger = 16
  final val KindBoxedLong = 17
  final val KindBoxedFloat = 18
  final val KindBoxedDouble = 19
  final val KindBoxedString = 20
  final val KindClass = 21
  final val KindInterface = 22
  final val KindJSType = 23
  final val KindJSTypeWithSuperClass = 24

  final val KindLastPrimitive = KindDouble
}
