/*
 * Scala.js (https://www.scala-js.org/)
 *
 * Copyright EPFL.
 *
 * Licensed under Apache License 2.0
 * (https://www.apache.org/licenses/LICENSE-2.0).
 *
 * See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 */

package org.scalajs.testsuite.javalib.lang

import java.math.BigInteger
import java.util.SplittableRandom

import org.junit.Test
import org.junit.Assert._

class MathTestOnJDK21 {

  @Test def testUnsignedMultiplyHigh(): Unit = {
    def test(expected: Long, x: Long, y: Long): Unit =
      assertEquals(expected, Math.unsignedMultiplyHigh(x, y))

    test(-4655528149793241951L, -3491544249150011246L, -1435735621922138183L)
    test(4723475310515791226L, -5748086171833985033L, 6861570794713764439L)
    test(1844940925490449716L, 2113050876768271470L, -2340575756699630680L)
    test(702124944283937448L, 2364425117167296916L, 5477830133394302018L)
    test(8604154842195983318L, -765591305295706482L, 8976713476968422536L)
    test(721433542721114290L, 2866411935332571322L, 4642772995997153672L)
    test(198977852337409286L, 901957528446724377L, 4069474895038101365L)
    test(763163907759431674L, 5160783458443768226L, 2727858939653224648L)
    test(3387911794594526182L, 4369265381816556396L, -4143208729009548760L)
    test(7271333002323704409L, -1757891743212949508L, 8037246439257825352L)
    test(2439931237179080842L, -6474169961931828112L, 3759324157819640760L)
    test(6061120068222317095L, -2837073725411217492L, 7162734907512678039L)
    test(34351029958289581L, 2814331433271609755L, 225156373132738607L)
    test(5537345867541993285L, -1010313517008906026L, 5858194527486398591L)
    test(-5335982525234939944L, -2717969804981747482L, -3070411578621565733L)
    test(8785453866123381013L, -8027031729027070236L, -2893241858030230601L)
    test(846995399721837047L, 8016550578873635720L, 1949006273527852101L)
    test(4706098605093773886L, -8117794498444021304L, 8404745896106734176L)
    test(8161884790484487335L, -1014727160850354519L, 8636992531719324619L)
    test(-8513922914337796266L, -7911312134726022659L, -1055125873522512866L)
    test(5454317624646219097L, -5009725974720812208L, 7487851886286018345L)
    test(2492015203153257923L, 5501297108904060131L, 8356132339400095318L)
    test(251150029847529372L, 2825249782885673228L, 1639819725946463245L)
    test(701745563060384928L, -862030064654873400L, 736146223360275347L)
    test(-7730043035170177278L, -81403377518056314L, -7682541838496528017L)
    test(7236963176581899295L, -5477193291802744595L, -8153526534093331950L)
    test(626928141670112235L, 1514687386182852255L, 7635095589684134756L)
    test(413586791425617421L, 2206621030247415833L, 3457471667819472989L)
    test(5275688490004831530L, 5303665000787184389L, -97305454699880484L)
    test(-4547690235532216689L, -4468474298913285824L, -104539126294685679L)
    test(366277061497431976L, 2447428253923437996L, 2760701647814215009L)
    test(6869979725009155017L, -6471585201942397935L, -7864107205517734491L)
    test(3791302630224081431L, -3133537597544878918L, 4567115935815546723L)
    test(1740958585965607218L, -1557363676960182057L, 1901491749479209603L)
    test(1523197267704952893L, 6322993002648583029L, 4443786377646975729L)
    test(-5259964406327079828L, -1435127053681489364L, -4147506711722433774L)
    test(461442857371067152L, -3905080403415491898L, 585360691015982209L)
    test(-5941004277830287560L, -823789104926622437L, -5356420579401640852L)
    test(-8706994437197957328L, -7948824177902058651L, -1332242280026816373L)
    test(-5824918531825640540L, -1108632841430213984L, -5017854248578702419L)
    test(-8207168723011034838L, -6116459797997975723L, -3127808865551126328L)
    test(73145162458483087L, 984457260399802488L, 1370592860022769137L)
    test(1646786118016093153L, 1899627239649590099L, -2455268783649962915L)
    test(3040972539165017704L, -1806601545829941920L, 3371127505138255794L)
    test(-7035139036718491109L, -5137998055321179172L, -2629554588180521105L)
    test(3814121656202007379L, 6827719277638332778L, -8141966856464601543L)
    test(846533671710128614L, 928822269112330348L, -1634281118080467412L)
    test(2465515036079121285L, -6936668916098982255L, 3951383831786888133L)
    test(-8705991089541820518L, -4627352440152123018L, -5444349891042507930L)
    test(-1725081446201736077L, -102123348177150214L, -1631993003537285149L)
    test(3162229868737586796L, -3928062681119615377L, 4017778440996329527L)
    test(-5644865433298065278L, -1848848427461824206L, -4218857359905179258L)
    test(8602545182711575119L, -7248610265558893317L, -4275726644671484627L)
    test(574312046131959731L, 3094727123103690882L, 3423302576293014745L)
    test(1498569573726223576L, -7522287153787738568L, 2530444268837256898L)
    test(9201094795447111684L, -7474596509362715910L, -2977553571653290816L)
    test(3390173448745695247L, 4278016163532080543L, -3828364997071413384L)
    test(1203823557488246474L, 7917135674481131658L, 2804881208044173681L)
    test(78424886362034171L, 980323435081771015L, 1475720926338487149L)
    test(2441060259411459766L, 5798689165809470750L, 7765481574589679868L)
    test(1218713916031010010L, 1847981405952407601L, -6281414035388066866L)
    test(3425204597140630L, 23488433971625858L, 2689999370748729443L)
    test(1973267136565988242L, -1929721405614247783L, 2203808433804858703L)
    test(68657367104675341L, 1589652507076814732L, 796718071475649415L)
    test(3001541031524236691L, 8704517430100436852L, 6360910835079676298L)
    test(681950840803061472L, 4077993211593106210L, 3084794892591474962L)
    test(-8032203953933386693L, -1297027813828962384L, -7244555458827535130L)
    test(1705455955228875706L, 7677829613973803154L, 4097526399626386343L)
    test(-7072562212974300041L, -4950443113989053629L, -2900512372222814349L)
    test(1553202529265923923L, -5818129186601545240L, 2268778469225152008L)
    test(468774576517241981L, 4408923425379013709L, 1961332463044936276L)
    test(3713249757582606154L, 3805244009484784339L, -445962050491898861L)
    test(-6492270872661604844L, -3676904101986751446L, -3516243262736404968L)
    test(-1570352970576497130L, -498180996573724276L, -1101931219921881504L)
    test(5938952698782807216L, -2212548245883761340L, 6748368792775950262L)
    test(6965609214550264138L, -44143931286210318L, 6982318232414802091L)
    test(5427827011873507182L, -6210411243958046988L, 8182658739140523648L)
    test(-4010444622072654726L, -2893048189377704445L, -1325236533881556505L)
    test(-751397756032611136L, -297794630894262553L, -461046011882216476L)
    test(547299415238293930L, 4622152711521934473L, 2184240304182297561L)
    test(378891801518625290L, -4298572905176069751L, 494008731657528393L)
    test(1743296278846509964L, 2577934180605703203L, -5972360304541326595L)
    test(1039517173945592548L, 5277562622670643081L, 3633440025065309218L)
    test(2800417145934889950L, 4637163034857372585L, -7306618526608114613L)
    test(1678445276921448048L, 4821090766475680470L, 6422167091396679498L)
    test(6227359204013573541L, -4999273910373625291L, 8542461897755272268L)
    test(-5499015746244333303L, -1511897164914852634L, -4343077705835106861L)
    test(2697793722365988629L, 6211672456183761935L, 8011612123978580051L)
    test(1911468969140043410L, -5555150943474614346L, 2735145185110353700L)
    test(2743615826392469850L, 6136958276954783995L, 8246883342207528968L)
    test(1464762398133852646L, -6115223270905044522L, 2191140697019557187L)
    test(457204414584490485L, -5068587596916665104L, 630425637481565869L)
    test(-6229688730810143122L, -4425525343688714952L, -2373612516159392266L)
    test(388393998755070731L, 797622384306174158L, 8982451891732844522L)
    test(5110014275194731110L, 8574583813914626477L, -7453426194589668982L)
    test(6332629791985833635L, -6221980493997883829L, -8891025443683788065L)
    test(1100817927132096284L, -5992086725542985450L, 1630434784827422367L)
    test(-6893218526017086868L, -566288691658266700L, -6527308893032530287L)
    test(6838523840226613906L, 7591397219780968602L, -1829447485155925067L)
    test(2870893831454164280L, 3649310365003545712L, -3934784696536939433L)
  }

}
