# Введение

Vue Test Utils — официальная библиотека модульного тестирования для Vue.js.

- [Сборка](installation/)
  - [Чем запускать тесты](installation/choosing-a-test-runner.md)
  - [Тестирование однофайловых компонентов с Jest](installation/testing-single-file-components-with-jest.md)
  - [Тестирование однофайловых компонентов с Mocha + webpack](installation/testing-single-file-components-with-mocha-webpack.md)
  - [Testing однофайловых компонентов с Karma](installation/testing-single-file-components-with-karma.md)
- [Руководства](guides/)
  - [Введение](guides/getting-started.md)
  - [Общие советы](guides/common-tips.md)
  - [Мышь, клавиши и другие события DOM](guides/dom-events.md)
  - [Тестирование асинхронной логики](guides/testing-async-components.md)
  - [Использование с TypeScript](guides/using-with-typescript.md)
  - [Использование с Vue Router](guides/using-with-vue-router.md)
  - [Использование с Vuex](guides/using-with-vuex.md)
- [API](api/)
  - [mount](api/mount.md)
  - [shallowMount](api/shallowMount.md)
  - [render](api/render.md)
  - [renderToString](api/renderToString.md)
  - [Опции монтирования](api/options.md)
    - [context](api/options.md#context)
    - [slots](api/options.md#slots)
    - [scopedSlots](api/options.md#scopedslots)
    - [stubs](api/options.md#stubs)
    - [mocks](api/options.md#mocks)
    - [localVue](api/options.md#localvue)
    - [attachToDocument](api/options.md#attachtodocument)
    - [attrs](api/options.md#attrs)
    - [propsData](api/options.md#propsdata)
    - [listeners](api/options.md#listeners)
    - [parentComponent](api/options.md#parentComponent)
    - [provide](api/options.md#provide)
    - [другие опции](api/options.md#другие-опции)
  - [Wrapper](api/wrapper/)
    - [attributes](api/wrapper/attributes.md)
    - [classes](api/wrapper/classes.md)
    - [contains](api/wrapper/contains.md)
    - [emitted](api/wrapper/emitted.md)
    - [emittedByOrder](api/wrapper/emittedByOrder.md)
    - [exists](api/wrapper/exists.md)
    - [destroy](api/wrapper/destroy.md)
    - [find](api/wrapper/find.md)
    - [findAll](api/wrapper/findAll.md)
    - [html](api/wrapper/html.md)
    - [is](api/wrapper/is.md)
    - [isEmpty](api/wrapper/isEmpty.md)
    - [isVueInstance](api/wrapper/isVueInstance.md)
    - [name](api/wrapper/name.md)
    - [props](api/wrapper/props.md)
    - [setChecked](api/wrapper/setChecked.md)
    - [setData](api/wrapper/setData.md)
    - [setMethods](api/wrapper/setMethods.md)
    - [setProps](api/wrapper/setProps.md)
    - [setSelected](api/wrapper/setSelected.md)
    - [setValue](api/wrapper/setValue.md)
    - [text](api/wrapper/text.md)
    - [trigger](api/wrapper/trigger.md)
    - [isVisible](api/wrapper/isVisible.md)
  - [WrapperArray](api/wrapper-array/)
    - [at](api/wrapper-array/at.md)
    - [contains](api/wrapper-array/contains.md)
    - [exists](api/wrapper/exists.md)
    - [destroy](api/wrapper-array/destroy.md)
    - [filter](api/wrapper-array/filter.md)
    - [is](api/wrapper-array/is.md)
    - [isEmpty](api/wrapper-array/isEmpty.md)
    - [isVueInstance](api/wrapper-array/isVueInstance.md)
    - [setChecked](api/wrapper-array/setChecked.md)
    - [setData](api/wrapper-array/setData.md)
    - [setMethods](api/wrapper-array/setMethods.md)
    - [setProps](api/wrapper-array/setProps.md)
    - [setValue](api/wrapper-array/setValue.md)
    - [trigger](api/wrapper-array/trigger.md)
    - [isVisible](api/wrapper-array/isVisible.md)
  - [Компоненты](api/components/)
    - [RouterLinkStub](api/components/RouterLinkStub.md)
  - [Селекторы](api/selectors.md)
  - [createWrapper](api/createWrapper.md)
  - [createLocalVue](api/createLocalVue.md)
  - [Конфигурация](api/config.md)
