## Чем запускать тесты

Test runner — это программа, которая запускает тесты.

Есть много популярных программ запуска тестов для JavaScript, и `vue-test-utils` работает с любой из них. Нет зависимости от используемого test runner.

Есть несколько вещей, которые следует учитывать при выборе программы запуска тестов: набор функций, производительность и поддержка предварительной компиляции однофайловых компонентов. После тщательного сравнения существующих библиотек мы рекомендуем два варианта конфигурации:

- [Jest](https://jestjs.io/docs/en/getting-started.html#content) наиболее функциональный способ запуска тестов. Он меньше всех требует конфигурирования, устанавливает JSDOM по умолчанию, предоставляет встроенные проверки (assertions) и имеет отличный интерфейс для работы через командную строку. Тем не менее, вам понадобится пре-процессор, чтобы иметь возможность импортировать однофайловые компоненты в свои тесты. Мы создали пре-процессор `vue-jest`, который может обрабатывать наиболее распространённые функции однофайловых компонентов, но в настоящее время он не имеет 100% паритетности функций с `vue-loader`.

- [mocha-webpack](https://github.com/zinserjan/mocha-webpack) — это обёртка вокруг webpack + Mocha, но с более оптимизированным интерфейсом и режимом отслеживания. Преимущества этой конфигурации в том, что мы можем получить полную поддержку однофайловых компонентов с помощью webpack + `vue-loader`, но для этого требуется больше настройки.

### Браузерное окружение

`vue-test-utils` полагается на браузерное окружение. Технически вы можете запустить его в реальном браузере, но это не рекомендуется из-за сложности запуска реальных браузеров на разных платформах. Вместо этого мы рекомендуем запускать тесты в Node с виртуальным браузерным окружением, реализуемым с помощью [JSDOM](https://github.com/tmpvar/jsdom).

Jest настраивает JSDOM автоматически. Для других программ запуска тестов вы можете вручную настроить JSDOM для тестов с помощью [jsdom-global](https://github.com/rstacruz/jsdom-global) в записи для ваших тестов:

```bash
npm install --save-dev jsdom jsdom-global
```

---

```js
// в настройке теста / entry
require('jsdom-global')()
```

### Тестирование однофайловых компонентов

Однофайловые компоненты Vue требуют предварительной компиляции, прежде чем могут быть запущены в Node или в браузере. Существует два рекомендуемых способа выполнения компиляции: с пре-процессором Jest, или непосредственно с помощью webpack.

Пре-процессор `vue-jest` поддерживает базовую функциональность однофайловых компонентов, но в настоящее время не обрабатывает блоки стилей или пользовательские блоки, которые поддерживаются только в `vue-loader`. Если вы полагаетесь на эти функции или другие конфигурации, специфичные для webpack, вам нужно будет использовать связку webpack + `vue-loader`.

Изучите следующие руководства по вариантам настройки:

- [Тестирование однофайловых компонентов с Jest](./testing-single-file-components-with-jest.md)
- [Тестирование однофайловых компонентов с Mocha + webpack](./testing-single-file-components-with-mocha-webpack.md)

### Дополнительные ресурсы

- [Сравнение производительности программ для запуска тестов](https://github.com/eddyerburgh/vue-unit-test-perf-comparison)
- [Пример проекта с Jest](https://github.com/vuejs/vue-cli/tree/dev/packages/%40vue/cli-plugin-unit-jest)
- [Пример проекта с Mocha](https://github.com/vuejs/vue-cli/tree/dev/packages/%40vue/cli-plugin-unit-mocha)
- [Пример проекта с tape](https://github.com/eddyerburgh/vue-test-utils-tape-example)
- [Пример проекта с AVA](https://github.com/eddyerburgh/vue-test-utils-ava-example)
- [tyu — Восхитительное веб-тестирование от egoist](https://github.com/egoist/tyu)
