---
id: overview
title: Overview
sidebar_label: Overview
---

CodeRoad is a VSCode extension that allows you to play interactive coding tutorials in your editor.

![CodeRoad Image](/gif/coderoad-example.gif)

CodeRoad is a platform for creating and playing interactive coding education tutorials.

What makes CodeRoad different?

## Real-World Experience

CodeRoad is the first tutorial platform to run in a real coding environment: Microsoft’s VSCode editor. As you play, the editor provides access to the same extensions and features real developers use.

Users love CodeRoad because it provides them more than just a certificate of completion. CodeRoad tutorials are made out of Git commits that provide a public-facing view of your progress to share on the social network for developers: GitHub. In addition, you build a portfolio in CodeRoad: write real code, push it to GitHub, and deploy your projects to the cloud. In the end, you have something for your efforts to build upon, customize, and show to peers or potential employers.

## A Better Way To Learn

It’s no secret that computer science departments have the highest dropout rates, and the number is even worse with online coding programs where 94% of students give up. When I was learning to code, I almost quit many times - only later did I recognize I struggled because the courses didn’t align well with how people learn.

Learning is the process of transferring knowledge from one medium into the user's mind. Similar to other interactive coding platforms like Codecademy or CodeSchool, I’ve aligned CodeRoad with the science of learning: practice doing, quick feedback, gamification, and hints or help when learners get stuck.

As long as interactive content remains difficult to produce, the primary medium for coding education will still be video and text. The tools for interactive content just haven’t been available… until CodeRoad.

## Create Tutorials

The primary focus of CodeRoad is to make producing interactive content simpler. Simple enough that a tutorial can be made in the same way as regular software - with unit tests, git commits, and basic documentation. CodeRoad is a working project today, and I have plans to make the process even smoother.

The ability of a software developer to generate interactive content is a big deal. With CodeRoad, creators can now produce one-click launching tutorials in a browser or even run them locally on a user's machine.
